package gov.va.med.mhv.vitals.web.validator;

import java.math.BigDecimal;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="LpidisLdlValidator")
public class LpidisLdlValidator implements Validator{
	private static final BigDecimal LDL_MIN_VALUE = new BigDecimal("10.0");
	private static final BigDecimal LDL_MAX_VALUE = new BigDecimal("1000.0");

	@Override
	public void validate(FacesContext context, UIComponent component,Object value) throws ValidatorException {
		
		BigDecimal lipidsLdl=(BigDecimal)value;
		
		if(lipidsLdl.compareTo(LDL_MAX_VALUE) > 0){
			String summary = "The LDL value must be less than or equal to 1,000.";
			String detail = "Enter a value less than or equal to 1,000.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}else  if(lipidsLdl.compareTo(LDL_MIN_VALUE) < 0){
			String summary = "The LDL value must be greater than or equal to 10.";
			String detail = "Enter a value greater than or equal to 10.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
		
	}

}
